package DAO;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;

import ClassesJava.*;

public class LieuxDAO {
	
	/**
	 * Parametres de connexion  la base de donnes oracle URL, LOGIN et PASSWORD
	 * sont des constantes
	 */
	final static String URL = "jdbc:oracle:thin:@localhost:1521:xe";
	final static String LOGIN = "BDD5"; 
	final static String PASSWORD = "BDD5"; 
	
	public LieuxDAO() {
	
	//Chargement du pilote de bases de donnes
	try {
		Class.forName("oracle.jdbc.OracleDriver");
		
	}catch (ClassNotFoundException e) {
				
		System.err.println("Impossible de charger le pilote de BDD, ne pas oublier d'importer le fichier .jar dans le projet");
		}
	}
	
	/**
     * Methode creer Lieu.
     * 
     * @param Un Lieu
     *           
     */

	public int creer_lieu( Lieu lieu ) {
		
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// Prparation de l'instruction SQL: chaque "?" reprsente une valeur
			//  communiquer dans l'insertion
			// Les getters permettent de rcuperer les valeurs des attributs
			// souhaits
				ps = connexion.prepareStatement("INSERT INTO LIEUX (IDLIEUX, EMPLACEMENT, HORAIRE_OUVERTURE, HORAIRE_FERMETURE, NBR_ACCES) VALUES (LIEUX_SEQUENCE.NEXTVAL, ?, ?, ?, ?)");
				ps.setString(1, lieu.getEmplacement());
				ps.setTime(2, lieu.getHoraireOuverture());
				ps.setTime(3, lieu.getHoraireFermerture());
				ps.setInt(4, lieu.getNombreAcces());

				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
		
	}
		
	/**
     * Methode Modifier lieu.
     * 
     * @param Un lieu et un nom d'emplacement
     *           
     */
	
	public int modifier_lieu(Lieu lieu, String emplacement) {
		
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// Prparation de l'instruction SQL: chaque "?" reprsente une valeur
			//  communiquer dans l'insertion
			// Les getters permettent de rcuperer les valeurs des attributs
			// souhaits
				ps = connexion.prepareStatement("UPDATE LIEUX SET EMPLACEMENT = ?, HORAIRE_OUVERTURE = ?, HORAIRE_FERMETURE = ?, NBR_ACCES = ? WHERE EMPLACEMENT = ?");
				ps.setString(1, emplacement);
				ps.setTime(2, lieu.getHoraireOuverture());
				ps.setTime(3, lieu.getHoraireFermerture());
				ps.setInt(4, lieu.getNombreAcces());
				ps.setString(5, lieu.getEmplacement());
				
				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
		
	}
	
	/**
     * Methode getLieu.
     * 
     * @param Un nom d'emplacement
     *           
     */
	
	public Lieu getLieu(String emplacement) {

		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		Lieu retour = null;

		// connexion à la base de données
		try {

			con = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			ps = con.prepareStatement("SELECT * FROM LIEUX WHERE EMPLACEMENT = ?");
			ps.setString(1, emplacement);

			// on exécute la requête
			// rs contient un pointeur situé juste avant la première ligne
			// retournée
			rs = ps.executeQuery();
			// passe à la première (et unique) ligne retournée
			if (rs.next())
				retour = new Lieu(rs.getString("EMPLACEMENT"),
						rs.getInt("NBR_ACCES"),
						rs.getTime("HORAIRE_FERMETURE"), rs.getTime("HORAIRE_OUVERTURE"));

		} catch (Exception ee) {
			
			ee.printStackTrace();
			
		} finally {
			// fermeture du ResultSet, du PreparedStatement et de la Connexion
			try {
				if (rs != null)
					rs.close();
			} catch (Exception ignore) {
			}
			try {
				if (ps != null)
					ps.close();
			} catch (Exception ignore) {
			}
			try {
				if (con != null)
					con.close();
			} catch (Exception ignore) {
			}
		}
		return retour;

	}
	
	/**
     * Methode get_id_lieu.
     * 
     * @param Un nom d'emplacement
     *           
     */
	
	public int get_Id_Lieu(String emplacement) {

		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		int retour = 0;

		// connexion à la base de données
		try {

			con = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			ps = con.prepareStatement("SELECT IDLIEUX FROM LIEUX WHERE EMPLACEMENT = ?");
			ps.setString(1, emplacement);

			// on exécute la requête
			// rs contient un pointeur situé juste avant la première ligne
			// retournée
			rs = ps.executeQuery();
			// passe à la première (et unique) ligne retournée
			if (rs.next())
				retour = rs.getInt("IDLIEUX");

		} catch (Exception ee) {
			
			ee.printStackTrace();
			
		} finally {
			// fermeture du ResultSet, du PreparedStatement et de la Connexion
			try {
				if (rs != null)
					rs.close();
			} catch (Exception ignore) {
			}
			try {
				if (ps != null)
					ps.close();
			} catch (Exception ignore) {
			}
			try {
				if (con != null)
					con.close();
			} catch (Exception ignore) {
			}
		}
		return retour;

	}
	
	/*public ArrayList<Lieu> recuperer_liste_lieu(ArrayList<Lieu> Liste_lieu){
		return Liste_lieu;
		
	}*/
	
	
	// main permettant de tester la classe
		public static void main(String[] args) throws SQLException {

			LieuxDAO lieuxDAO = new LieuxDAO();
			Time open = new Time(9,0,0);
			Time close = new Time(10,0,0);
			// test de la méthode ajouter

			Lieu a1 = new Lieu("Armani", 2, open, close);
			
			int retour = lieuxDAO.creer_lieu(a1);

			System.out.println(retour + " Lieu cr");
			
			int modif = lieuxDAO.modifier_lieu(a1, "Charpak");
			
			System.out.println(modif + " Lieu modifi");

		}
}
